<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Remito extends Model 
{

    protected $table = 'remito';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function detalle()
    {
        return $this->hasOne('App\Models\DetalleRemito');
    }

    public function orden()
    {
        return $this->belongsTo('App\Models\OrdenCompra');
    }

    public function proveedor()
    {
        return $this->belongsTo('App\Models\Proveedor');
    }

    public function destino()
    {
        return $this->belongsTo('App\Models\Destino');
    }

}